<?php
function maskErrors()
{
}

require_once dirname(__FILE__) . '/../utils/MainInfo.php';

class PlayerConfig extends CFormModel
{
    protected $conf = array(
        "_deviceName" => array("reporting", "deviceName"),
        "_screenId" => array("multiscreen", "screenId"),

        "_NetAPIEnabled" => array("interactivity", "remoteClientsEnabled"),
        "_sharedVarPort" => array("interactivity", "sharedVarPort"),
        "_sharedVarPSK" => array("interactivity", "sharedVarPSK"),
        "_sharedVarDefaultServer" => array(
            "interactivity",
            "sharedVarDefaultServer",
        ),

        "_overscan" => array("svgrender", "overScanMargin"),
        "_orientation" => array("svgrender", "screenOrientation"),
        "_mute" => array("svglib", "mute"),
        "_audioPowerSave" => array("svgrender", "audioPowerSave"),
        "_audioOutput" => array("displayV4L2", "audioOutput"),
        "_audioOutputDSOS" => array("displayEGL", "audioOutput"),
        "_surround" => array("svgrender", "audioLayout"),
        "_volume" => array("svgrender", "volume"),

        "_events" => array("interactivity", "allowEvents"),
        "_usbIOAPI" => array("interactivity", "allowUSBIOAPI"),
        "_latency" => array("svgrender", "maxLatency"),
        "_interlatency" => array("svgrender", "interactLatency"),
        // Overlay
        '_overlay' => array('player', 'overlay', 'href'),

        "_https_useDefaultCA" => array("https", "useDefaultCA"),

        "_videoOutputSelector" => array("displayEGL", "output"),

        "_canvas" => array("displayEGL", "canvas"),

        "_networkLog" => array("networkLog", "href"),
        "_cookieLog" => array("cookieLog", "href"),
        "_cacheLog" => array("cacheLog", "href"),

        "debugstream" => array("svgrender", "capture-stream"),

        "checkStart" => array("cacheManager", "checkStart"),
        "cleanStart" => array("cacheManager", "cleanStart"),
        "cleanExit" => array("cacheManager", "cleanExit"),
        "maxFile" => array("cacheManager", "maxFile"),
        "minFreeSpace" => array("cacheManager", "minFreeSpace"),
        "maxFileAge" => array("cacheManager", "maxFileAge"),
        "maxFileSize" => array("cacheManager", "maxFileSize"),
        //"maxThreads"  => array("cacheManager", "maxThreads"),
        //"checkPeriod"  => array("cacheManager", "checkPeriod"),

        "LMFactor" => array("cache", "LMFactor"),
        "maxDuration" => array("cache", "maxDuration"),
        "maxDurationFile" => array("cache", "maxDurationFile"),
        "minDuration" => array("cache", "minDuration"),
        "errorDuration" => array("cache", "errorDuration"),
        "errorDurationFile" => array("cache", "errorDurationFile"),

        // WebRTC
        "_echoCancellation" => array("svglib", "echoCancellation"),
    );

    protected $_latencies = array(
        "0.25" => "250ms",
        "0.5" => "500ms",
        "1" => "1000ms",
    );

    public $configName = "/etc/raperca/spxconfig.xml";
    protected $_deviceName = null;
    protected $_screenId = null;

    protected $_NetAPIEnabled = null;
    protected $_sharedVarPort = null;
    protected $_sharedVarPSK = null;
    protected $_sharedVarDefaultServer = null;

    protected $_overscan = null;
    protected $_orientation = null;
    protected $_videoOutputSelector = null;
    protected $_canvas = null;

    protected $_events = null;
    protected $_usbIOAPI = null;
    protected $_interlatency = null;
    protected $_latency = null;
    // Overlay
    protected $_overlay = null;

    protected $_networkLog = null;
    protected $_cookieLog = null;
    protected $_cacheLog = null;

    protected $_mute = null;
    var $_audioPowerSave = null;
    var $_audioOutput = null;
    var $_audioOutputDSOS = null;
    var $_surround = null;
    protected $audioOutputModified = false;
    protected $_volume = null;

    protected $_https_useDefaultCA = null;

    var $backupMode = false;

    var $debugstream = null;

    var $LMFactor;
    var $maxDuration;
    var $maxDurationFile;
    var $minDuration;
    var $errorDuration;
    var $errorDurationFile;

    var $checkStart;
    var $cleanStart;
    var $cleanExit;
    var $maxFile;
    var $minFreeSpace;
    var $maxFileAge;
    var $maxFileSize;

    // WebRTC
    protected $_echoCancellation = null;

    public $domdoc = null;

    protected $errstr;

    public static function getVideoOutputRegion($output, $mode)
    {
        list($width, $height) = explode('x', $mode->resolution);
        if (
            $output['orientation'] === 'rotateRight' ||
            $output['orientation'] === 'rotateLeft'
        ) {
            list($width, $height) = array($height, $width);
        }
        $region = new Region();
        $region->set($output['x'], $output['y'], $width, $height);
        return $region;
    }

    public function init()
    {
        parent::init();
        $this->errstr =
            " Please try again, reset the device to factory default or contact " .
            Yii::app()->branding->email;
        if (
            Yii::app()->hasProperty('user') &&
            Yii::app()->user->checkAccess('useAdvancedConfig')
        ) {
            $this->enableLowLatencySetup();
        }
    }
    public function enableLowLatencySetup()
    {
        $this->_latencies = array(
            "0.05" => "50ms",
            "0.1" => "100ms",
            "0.2" => "200ms",
            "0.25" => "250ms",
            "0.3" => "300ms",
            "0.4" => "400ms",
            "0.5" => "500ms",
            "1" => "1000ms",
        );
    }
    public function rules()
    {
        $res = array(
            array(
                "overscan",
                'numerical',
                'on' => 'display, wizard',
                'min' => 0,
                'max' => 5,
                'allowEmpty' => false,
            ),
            array(
                "orientation",
                'in',
                'on' => 'display, wizard',
                'range' => array(
                    "horizontal",
                    "rotateRight",
                    "rotateLeft",
                    "rotate180",
                    "flipVert",
                    "flipHor",
                ),
                'allowEmpty' => false,
            ),
            array(
                'videoOutputSelector',
                'match',
                'pattern' => '/^(?<output>card\d+-[-\w]+-\d+(?::\d+){0,2}' .
                    '(?::(?:horizontal|rotateRight|rotateLeft|rotate180|' .
                    'flipVert|flipHor))?)(,(?&output))*$/',
                'allowEmpty' => true,
                'on' => 'display, wizard',
            ),
            array(
                "audio, audioPowerSave, surround",
                'safe',
                'on' => 'display, wizard',
            ),
            array("audioOutput", 'safe', 'on' => 'display, wizard'),
            array("volume", 'numerical', 'on' => 'display, wizard', 
                'integerOnly' => true, 'min' => 1, 'max' => 100, 
                'tooSmall' => '{attribute} is too low (minimum is {min}).', 
                'tooBig' => '{attribute} is too high (maximum is {max}).'), 
            array(
                'canvas',
                'match',
                'pattern' => "/^\d+ \d+$/",
                'allowEmpty' => true,
                'on' => 'display',
            ),
            array('events, usbIOAPI, interlatency', 'safe', 'on' => 'inter'),
            array(
                'latency',
                'in',
                'on' => 'inter',
                'range' => array(
                    '1',
                    '0.5',
                    '0.4',
                    '0.3',
                    '0.25',
                    '0.2',
                    '0.1',
                    '0.05',
                ),
                'allowEmpty' => false,
            ),
            // Overlay
            array('overlay', 'SimpleURLValidator', 'on' => 'inter'),
            array('deviceName', 'checkNames', 'on' => 'id, wizard'),
            array('screenId', 'type', 'type' => 'string', 'on' => 'id, wizard'),
            array('NetAPIEnabled', 'safe', 'on' => 'netapi'),
            array('LegacyNetAPIEnabled', 'safe', 'on' => 'netapi'),
            array(
                'sharedVarPSK',
                'match',
                'pattern' => "/^[0-9a-fA-F]{32,64}$/",
                'on' => 'netapi',
            ),
            array(
                'sharedVarDefaultServer',
                'checkServerName',
                'on' => 'netapi',
            ),
            array('HTTPSUseDefaultCA', 'safe', 'on' => 'https'),
            array(
                'sharedVarPort',
                'numerical',
                'on' => 'netapi',
                'min' => 1025,
                'allowEmpty' => true,
            ),
            array(
                "debugstream",
                'safe',
                'on' => 'player',
            ),
            array(
                "LMFactor, maxDuration, maxDurationFile, minDuration, errorDuration, errorDurationFile",
                'safe',
                'on' => 'cache',
            ),
            array(
                "checkStart, cleanStart, cleanExit, maxFile, minFreeSpace, maxFileAge, maxFileSize",
                'safe',
                'on' => 'cache',
            ),
            array(
                "checkStart, cleanStart, cleanExit, maxFile, minFreeSpace, maxFileAge, maxFileSize",
                'safe',
                'on' => 'cache',
            ),
            array("httpLogs", 'safe', 'on' => 'player'),

            // WebRTC
            array('echoCancellation', 'boolean', 'on' => 'WebRTC'),
        );
        return $res;
    }

    public function checkServerName($attribute, $params)
    {
        $value = $this->$attribute;
        if ($value == "") {
            return true;
        }

        if (
            preg_match("/^\[([a-fA-F0-9:]*)\](?::\d*)?$/", $value, $IPv6Match)
        ) {
            if (
                !filter_var($IPv6Match[1], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)
            ) {
                $this->addError($attribute, 'Invalid IPv6 format');
                return false;
            }
        } else {
            $valid =
                preg_match(
                    "/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*\.?$/i",
                    $value
                ) && //valid chars check
                preg_match("/^.{1,253}$/", $value) && //overall length check
                preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*\.?$/", $value); //length of each label

            if (
                !$valid &&
                !filter_var($value, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)
            ) {
                $this->addError($attribute, 'Invalid IP format');
                return false;
            }
        }
        return true;
    }

    public function attributeLabels()
    {
        return array(
            'deviceName' => 'Device Name',
            'screenId' => 'Multiscreen ID',
            'overscan' => 'Overscan percentage',
            'orientation' => 'Screen orientation',
            'videoOutputSelector' => "Video Output Selector",
            'audio' => 'Enable audio output',
            'surround' => 'Enable Surround',
            'audioPowerSave' => 'Disable audio when screen is turned off',
            'audioOutput' => 'Target audio output',
            'events' => 'Accept touchscreen and keyboard events',
            'usbIOAPI' => 'USB I/O API',
            'latency' => 'Maximum rendering latency',
            'interlatency' => 'Limit latency to 60ms when events are received',
            'NetAPIEnabled' => 'Enable secure server',
            'LegacyNetAPIEnabled' => 'Enable legacy unprotected server',
            'sharedVarPort' => 'Port',
            'sharedVarPSK' => 'PSK key',
            'sharedVarDefaultServer' => 'Default network API server address',
            "debugstream" => "Capture stream packets",
            "httpLogs" => "Capture http packets",

            "HTTPSUseDefaultCA" =>
                "Enable full verification of HTTPS certificates",

            "checkStart" => "Check cache on start (on|off)",
            "cleanStart" => "Clean cache on startup (on|off)",
            "cleanExit" => "Delete cache on exit (on|off)",
            "maxFile" => "Maximum number of cached files (0-...)",
            "minFreeSpace" => "Minimum free space (0.00-1.00)",
            "maxFileAge" => "Maximum age of cached files (in sec)",
            "maxFileSize" => "Maximum size for one file (KB, MB)",

            "LMFactor" => "LM-factor (0.0-1.0)",
            "maxDuration" => "Maximum cache time (sec)",
            "maxDurationFile" => "Maximum cache time for files (sec)",
            "minDuration" => "Minimum cache time (sec)",
            "errorDuration" => "Missing files check interval (sec)",
            "errorDurationFile" => "Missing local files check interval (sec)",

            // WebRTC
            "echoCancellation" => "Enable Echo Cancellation",
        );
    }
    public function getOrientationsList($wizard = false)
    {
        if ($wizard) {
            return array(
                "horizontal" => "Horizontal",
                "rotateRight" => "Vertical (CW)",
                "rotateLeft" => "Vertical (CCW)",
            );
        } else {
            return array(
                "horizontal" => "Horizontal",
                "rotateRight" => "Vertical (CW)",
                "rotateLeft" => "Vertical (CCW)",
                "rotate180" => "Rotate 180",
                "flipVert" => "Flip Vertical",
                "flipHor" => "Flip Horizontal",
            );
        }
    }
    public function hasVideoOutputSelector()
    {
        $model = Yii::app()->device->model;
        return substr($model, 0, 5) == 'DSOS|' ||
            substr($model, 0, 5) == 'dsos|' ||
            $model == "fukiran" || $model == "tsubaki";
    }
    public function getVideoOutputSelectorList()
    {
        $response = array();
        $screeninfo = new ScreenInfoDRM();
        $screeninfo->load();
        $type2Name = array(
            "DP" => "DisplayPort / HDMI",
            "HDMI-A" => "HDMI",
        );

        $prefered = null;
        foreach ($screeninfo->screens as $screen) {
            $displayName = $screen['displayName'];

            if ($displayName === false) {
                continue;
            }

            if ($screen['status'] === "connected") {
                $prefered = $screen['name'];
                $displayName .= " (connected)";
            }
            $response[$screen['name']] = $displayName;
        }
        if ($prefered !== null && $this->getVideoOutputSelector() === "") {
            $this->setVideoOutputSelector($prefered);
        }
        return $response;
    }
    public function getAudiooutputList($surround)
    {
        if (Yii::app()->device->model == "ikebana") {
            return array(
                'hdmi' => 'HDMI',
                'jack' => 'Line-out',
            );
        }
        $info = ScreenInfoDRM::getAudioInfo($surround);

        $audioInfo = array();
        foreach ($info as $audio) {
            if (!isset($audio["id"]) || !isset($audio["name"])) {
                continue;
            }
            $audioInfo[$audio["id"]] = $audio["name"];
        }
        if (!count($audioInfo)) {
            syslog(
                LOG_NOTICE,
                'no audio detected: empty list: ' . print_r($info, true)
            );
            return array("" => "<no audio detected>");
        }

        return $audioInfo;
    }

    public function checkNames($attribute)
    {
        $value = $this->$attribute;
        if (empty($value)) {
            return true;
        }
        if (
            preg_match('/[^\w\d-]/', $value) ||
            strlen($value) > 63 ||
            $value[0] == "-" ||
            $value[strlen($value) - 1] == "-"
        ) {
            $this->addError(
                $attribute,
                "Device name ('" .
                    htmlspecialchars($value) .
                    "') is not valid. The name may contain only ASCII letters, digits and the hyphen"
            );
            return false;
        }
        return true;
    }

    public function loadConfig()
    {
        if ($this->domdoc !== null) {
            return true;
        } // allready loaded

        if (!file_exists($this->configName)) {
            if (!$this->hasErrors()) {
                $this->addError(
                    'file',
                    "Cannot find the config file." . $this->errstr
                );
            }
            return false;
        }
        $spxconf = file_get_contents($this->configName);
        if (!$spxconf || $spxconf == "") {
            if (!$this->hasErrors()) {
                $this->addError(
                    'file',
                    "Config file is empty." . $this->errstr
                );
            }
            return false;
        }
        $this->domdoc = new DOMDocument();
        $this->domdoc->preserveWhiteSpace = false;
        $this->domdoc->formatOutput = true;

        set_error_handler('maskErrors'); // make sure no errors are generated when trying to load the xml doc
        if (!$this->domdoc->loadXML($spxconf)) {
            if (!$this->hasErrors()) {
                $this->addError(
                    'file',
                    "Cannot parse the config file." . $this->errstr
                );
            }
            $this->domdoc = null;

            restore_error_handler();
            return false;
        }
        restore_error_handler();

        return true;
    }

    public function saveConfig($save = false)
    {
        if ($this->domdoc === null && !$this->loadConfig()) {
            return false;
        }

        if ($this->_NetAPIEnabled) {
            $this->getSharedVarPSK();
        }

        foreach ($this->conf as $var => $loc) {
            if ($this->$var !== null) {
                if (isset($loc[2])) {
                    $nodeName = $loc[0];
                    $nodeName2 = $loc[1];
                    $attribute = $loc[2];
                } else {
                    $nodeName = $loc[0];
                    $nodeName2 = null;
                    $attribute = $loc[1];
                }
                $node = $this->domdoc->getElementsByTagName($nodeName);
                if ($node->length == 0) {
                    $node = $this->domdoc->createElement($nodeName);
                    $this->domdoc->documentElement->appendChild($node);
                } else {
                    $node = $node->item(0);
                }

                if ($nodeName2 !== null) {
                    $basenode = $node;
                    for (
                        $n2 = $node->firstChild;
                        $n2 != null;
                        $n2 = $n2->nextSibling
                    ) {
                        if ($n2->localName == $nodeName2) {
                            break;
                        }
                    }
                    $node = $n2;
                    $nodeName = $nodeName2;
                } else {
                    $basenode = $this->domdoc->documentElement;
                }
                $changed = false;
                if ($attribute === null) {
                    if ($node === null) {
                        $old = "";
                    } else {
                        $old = $node->textContent;
                    }
                    if ($this->$var != $old) {
                        if ($node === null) {
                            $node = $this->domdoc->createElement($nodeName);
                            $basenode->appendChild($node);
                        }
                        $node->textContent = $this->$var;
                        $changed = true;
                    }
                } else {
                    if ($attribute === "href") {
                        $xlinkNS = 'http://www.w3.org/1999/xlink';
                        $old = $node ?
                            $node->getAttributeNS($xlinkNS, "href") : '';
                        if ($this->$var != $old) {
                            if ($node === null) {
                                $node = $this->domdoc->createElement($nodeName);
                                $basenode->appendChild($node);
                            }    
                            $node->setAttributeNS(
                                $xlinkNS,
                                "xlink:href",
                                $this->$var
                            );
                            $changed = true;
                        }
                    } else {
                        $old = $node->getAttribute($attribute);
                        if ($this->$var != $old) {
                            if ($node === null) {
                                $node = $this->domdoc->createElement($nodeName);
                                $basenode->appendChild($node);
                            }    
                            $node->setAttribute($attribute, $this->$var);
                            $changed = true;
                        }
                    }
                }
                if ($changed) {
                    $save = true;
                    ${$var . 'Changed'} = true;
                }
            }
        }
        if ($save) {
            Tools::save_file($this->configName, $this->domdoc->saveXML());
            Tools::reconfig_player();

            if ($this->debugstream !== null) {
                Tools::restart_content();
            }
            if ($this->_deviceName !== null) {
                Tools::addReason("device name changed");
            }
            if (
                $this->_NetAPIEnabled !== null ||
                $this->_sharedVarPort != null
            ) {
                Tools::addReason("nework api config change");
            }
            if ($this->_events !== null) {
                Tools::addReason("interactivity config change");
            }
            if ($this->audioOutputModified || $this->_volume !== null) {
                Tools::addReason("audio config change");
            }
            if ($this->_usbIOAPI !== null) {
                Tools::addReason("USB I/O API config change");
            }
            // Overlay
            if (isset($_overlayChanged)) {
                Tools::addReason("overlay change");
            }
            if ($this->_https_useDefaultCA !== null) {
                Tools::addReason("HTTPS certificates config change");
            }
            if ($this->_orientation !== null) {
                Tools::restart_content();
            }
            if (isset($_videoOutputSelectorChanged)) {
                Tools::addReason("video output selector change");
            }
            if (isset($_canvasChanged)) {
                Tools::addReason("canvas change");
            }
            // WebRTC
            if ($this->_echoCancellation !== null) {
                Tools::addReason("WebRTC change");
            }
        }
        if ($this->_https_useDefaultCA !== null) {
            // must also save this for the uploader
            $pull = new PullModeConfig();
            $pull->load();
            if (
                $save ||
                $pull->https_useDefaultCA !==
                    ($this->_https_useDefaultCA == "true")
            ) {
                $pull->https_useDefaultCA =
                    $this->_https_useDefaultCA == "true";
                $pull->save();
            }
        }

        if ($this->_deviceName !== null) {
            Tools::reload_mdns();
            if (!Tools::setSafeModeData("devname", $this->_deviceName, false)) {
                $this->addError(
                    'deviceName',
                    "Failed saving device name for recovery console, please try again."
                );
            }
        }
        return $save;
    }

    public function refresh($ip) {
        $sharedVarDefaultServer = $this->sharedVarDefaultServer;
        if ($sharedVarDefaultServer) {
            $this->setsharedVarDefaultServer($sharedVarDefaultServer, $ip);
            $this->saveConfig();
        }
    }

    public function readConfigItem(&$var, $nodeName, $attribute)
    {
        if ($this->domdoc === null && !$this->loadConfig()) {
            return false;
        }

        $node = $this->domdoc->getElementsByTagName($nodeName);
        if ($node->length == 1) {
            $node = $node->item(0);
            if ($attribute === null) {
                $var = $node->textContent;
            } else {
                if ($attribute === "href") {
                    $xlinkNS = 'http://www.w3.org/1999/xlink';
                    $var = $node->getAttributeNS($xlinkNS, "href");
                } else {
                    $var = $node->getAttribute($attribute);
                }
            }
        } else {
            $var = "";
        }
        return true;
    }
    public function getVar($name, $default = "", $prefix = "_")
    {
        $var = $prefix . $name;
        if ($this->$var === null) {
            if (isset($this->conf[$var][2])) {
                $nodeName = $this->conf[$var][1];
                $attribute = $this->conf[$var][2];
            } else {
                $nodeName = $this->conf[$var][0];
                $attribute = $this->conf[$var][1];
            }
            if (!$this->readConfigItem($this->$var, $nodeName, $attribute)) {
                if (!$this->hasErrors()) {
                    $this->addError($name, "Cannot read configuration file");
                }
                return "error";
            }
            if ($this->$var == "") {
                $this->$var = $default;
            }
        }
        return $this->$var;
    }

    public function getDeviceName()
    {
        if ($this->backupMode) {
            $name = $this->getVar("deviceName", "");
            if ($name == Yii::app()->device->serial) {
                return "";
            }
            return $name;
        } else {
            $name = $this->getVar("deviceName", "");
            if ($name == "") {
                return Yii::app()->device->serial;
            }
            return $name;
        }
    }
    public function setDeviceName($deviceName)
    {
        $this->_deviceName = $deviceName;
    }

    public function getScreenId()
    {
        if ($this->backupMode) {
            $name = $this->getVar("screenId", "");
            if ($name == Yii::app()->device->serial) {
                return "";
            }
            return $name;
        } else {
            return $this->getVar("screenId", Yii::app()->device->serial);
        }
    }
    public function setScreenId($screenId)
    {
        $this->_screenId = $screenId;
    }

    public function getLegacyNetAPIEnabled()
    {
        if (
            !$this->getNetAPIEnabled() ||
            $this->getVar("sharedVarPort", 0) == 0
        ) {
            return false;
        } else {
            return true;
        }
    }
    public function setLegacyNetAPIEnabled($val)
    {
        if (!$val) {
            $this->setsharedVarPort("");
        } else {
            $this->setNetAPIEnabled(1);
            if ($this->getsharedVarPort() == "") {
                $this->setsharedVarPort(1234);
            }
        }
    }

    public function getNetAPIEnabled()
    {
        if ($this->getVar("NetAPIEnabled", "false") == "true") {
            return true;
        } else {
            return false;
        }
    }
    public function setNetAPIEnabled($val)
    {
        $this->_NetAPIEnabled = $val ? "true" : "false";
    }

    public function getHTTPSUseDefaultCA()
    {
        if ($this->getVar("https_useDefaultCA", "true") == "true") {
            return true;
        } else {
            return false;
        }
    }
    public function setHTTPSUseDefaultCA($val)
    {
        $this->_https_useDefaultCA = $val ? "true" : "false";
    }

    public function getsharedVarPort()
    {
        $port = $this->getVar("sharedVarPort", 1234);
        if ($port == 0) {
            return 1234;
        }
        return $port;
    }
    public function setsharedVarPort($val)
    {
        if ($val == "") {
            $this->_sharedVarPort = 0;
        } else {
            $this->_sharedVarPort = $val;
        }
    }

    public function getsharedVarPSK()
    {
        $psk = $this->getVar("sharedVarPSK", "");
        if ($psk == "") {
            $psk = bin2hex(openssl_random_pseudo_bytes(16));
            $this->_sharedVarPSK = $psk;
        }
        return $psk;
    }
    public function setsharedVarPSK($val)
    {
        $this->_sharedVarPSK = $val;
    }

    protected function formatSharedVarServer($name, $ip = null)
    {
        if (preg_match("/^\[([a-fA-F0-9:]*)\](?::\d*)?$/", $name, $IPv6Match)) {
            if (!$ip) {
                $ip = new IPConfig();
                $ip->loadIP();
            }
            $address =  $ip->resolveLinkLocalAddress($IPv6Match[1]);
            $name = preg_replace(
                "/^\[[a-fA-F0-9:]*\](:\d*)?$/",
                "[" . $address . "]$1",
                $name
            );
        }
        return $name;
    }
    protected function cleanSharedVarServer($name)
    {
        $name = preg_replace(
            "/^\[([a-fA-F0-9:]*)(?:%\w*)?\](:\d*)?$/",
            "[$1]$2",
            $name
        );
        return $name;
    }

    public function getsharedVarDefaultServer()
    {
        return $this->cleanSharedVarServer(
            $this->getVar("sharedVarDefaultServer", "")
        );
    }
    public function setsharedVarDefaultServer($val, $ip =null)
    {
        $this->_sharedVarDefaultServer = 
            $this->formatSharedVarServer($val, $ip);
    }

    public function getOverscan()
    {
        return $this->getVar("overscan", 3);
    }
    public function setOverscan($overscan)
    {
        $this->_overscan = $overscan;
    }

    public function getOrientation()
    {
        return $this->getVar("orientation", 'horizontal');
    }
    public function setOrientation($orientation)
    {
        $this->_orientation = $orientation;
    }

    public function getVideoOutputSelector()
    {
        return $this->getVar("videoOutputSelector", '');
    }
    public function setVideoOutputSelector($videoOutputSelector)
    {
        $this->_videoOutputSelector = $videoOutputSelector;
    }
    public function getVideoOutputName()
    {
        $outputs = explode(',', $this->getVideoOutputSelector());
        if (count($outputs) === 1 ) {
            return explode(':', $outputs[0])[0];
        } else {
            return '';
        }
    }
    public function hasMultipleVideoOutputs()
    {
        return count(explode(',', $this->getVideoOutputSelector())) > 1;
    }
    public function getVideoOutputs()
    {
        if (!($outputs = $this->getVideoOutputSelector())) {
            return array();
        }
        $outputs = explode(',', $outputs);
        $outputConfigs = array();
        foreach ($outputs as $output) {
            $parameters = explode(':', $output);
            $outputConfig =
                array('x' => 0, 'y' => 0, 'orientation' => 'horizontal');
            if (isset($parameters[1])) {
                $outputConfig['x'] = $parameters[1];
            }
            if (isset($parameters[2])) {
                $outputConfig['y'] = $parameters[2];
            }
            if (isset($parameters[3])) {
                $outputConfig['orientation'] = $parameters[3];
            }
            $outputConfigs[$parameters[0]] = $outputConfig;
        }
        return $outputConfigs;
    }

    public function getCanvas()
    {
        return $this->getVar("canvas", '');
    }
    public function setCanvas($canvas)
    {
        $this->_canvas = $canvas;
    }

    public function getHttpLogs()
    {
        $resp = "";
        if ($this->getVar("networkLog", "") !== "") {
            $resp = "network";
        }
        if ($this->getVar("cookieLog", "") !== "") {
            $resp = ($resp === "" ? "" : $resp . ",") . "cookie";
        }
        if ($this->getVar("cacheLog", "") !== "") {
            $resp = ($resp === "" ? "" : $resp . ",") . "cache";
        }
        if ($resp === "network,cookie,cache") {
            $resp = "all";
        }
        return $resp;
    }
    public function setHttpLogs($input)
    {
        $features = array_map('trim', explode(",", $input));

        if (in_array("all", $features)) {
            $features = array("network", "cookie", "cache");
        }

        $this->_networkLog = in_array("network", $features)
            ? "/srv/raperca/capture/HTTP-player-network-" .
                date('Y-m-d-His') .
                ".json"
            : "";
        $this->_cookieLog = in_array("cookie", $features)
            ? "/srv/raperca/capture/HTTP-player-cookie-" .
                date('Y-m-d-His') .
                ".json"
            : "";
        $this->_cacheLog = in_array("cache", $features)
            ? "/srv/raperca/capture/HTTP-player-cache-" .
                date('Y-m-d-His') .
                ".json"
            : "";
    }

    public function getAudio()
    {
        if ($this->getVar("mute") == "off") {
            return true;
        } else {
            return false;
        }
    }
    public function setAudio($audio)
    {
        $this->_mute = $audio ? "off" : "on";
    }
    public function getAudioPowerSave()
    {
        if ($this->getVar("audioPowerSave", 'off') == "on") {
            return true;
        } else {
            return false;
        }
    }
    public function setAudioPowerSave($audioPowerSave)
    {
        $this->_audioPowerSave = $audioPowerSave ? "on" : "off";
    }
    public function getSurround()
    {
        if (Yii::app()->device->model == "ikebana") {
            return false;
        }
        return $this->getVar("surround", "3") !== "3";
    }
    public function setSurround($enabled)
    {
        // do nothing, this is set by the audio output
    }
    public function getAudioOutput()
    {
        if (Yii::app()->device->model == "ikebana") {
            return $this->getVar("audioOutput", 'hdmi');
        } else {
            return $this->getVar("audioOutputDSOS", 'hdmi');
        }
    }

    public function setAudioOutput($audioOutput)
    {
        $this->audioOutputModified = true;
        if (Yii::app()->device->model == "ikebana") {
            $this->_audioOutput = $audioOutput;
        } else {
            $output = array();
            $ret = 10;
            exec(
                "spxaudiocfg -s " . escapeshellarg($audioOutput),
                $output,
                $ret
            );
            $this->_audioOutputDSOS = $audioOutput;
        }
        if (Yii::app()->device->model == "fukiran") {
            $fukiran_audio = "snd_hda_intel";
            if (
                $audioOutput ===
                "alsa_card.0/output:analog-stereo/analog-output"
            ) {
                $fukiran_audio = "snd_soc_skl";
            }
            Tools::save_file(
                "/etc/modprobe.d/fukiran-audio.conf",
                "alias fukiran-audio $fukiran_audio\n"
            );
        }
        if (Yii::app()->device->model != "ikebana") {
            if (strpos($audioOutput, "hdmi-surround71") !== false) {
                $this->_surround = "1599";
            } elseif (strpos($audioOutput, "hdmi-surround") !== false) {
                $this->_surround = "1551";
            } else {
                $this->_surround = "3";
            }
        }
    }

    public function getVolume()
    {
        return $this->getVar("volume", "100");
    }

    public function setVolume($volume)
    {
        $this->_volume = $volume;
    }

    public function getEvents()
    {
        $ev = $this->getVar("events");
        if ($ev == "false" || $ev == "off") {
            return false;
        } else {
            return true;
        }
    }
    public function setEvents($events)
    {
        $this->_events = $events ? "on" : "off";
    }
    public function getUsbIOAPI()
    {
        $ev = $this->getVar("usbIOAPI", "off");
        if ($ev == "false" || $ev == "off") {
            return false;
        } else {
            return true;
        }
    }
    public function setUsbIOAPI($usbIOAPI)
    {
        $this->_usbIOAPI = $usbIOAPI ? "on" : "off";
    }
    public function getLatencies()
    {
        $latency = $this->getLatency();
        if (!isset($this->_latencies[$latency])) {
            $this->enableLowLatencySetup();
        }
        return $this->_latencies;
    }
    public function getLatency()
    {
        $lat = $this->getVar("latency", "1");
        if (substr($lat, -2) == "ms") {
            $lat = strval(intval(substr($lat, 0, -2)) / 1000);
        }
        if (substr($lat, -1) == "s") {
            $lat = substr($lat, 0, -1);
        }
        return min($lat, "1");
    }
    public function setLatency($latency)
    {
        $this->_latency = min($latency, "1");
    }
    public function getInterLatency()
    {
        $ilat = $this->getVar("interlatency", "0.06");
        if ($ilat == "0.06" || $ilat == "60ms") {
            return true;
        } else {
            return false;
        }
    }
    public function setInterLatency($latency)
    {
        $this->_interlatency = $latency ? "0.06" : "1";
    }

    // Overlay
    public function getOverlay()
    {
        return $this->getVar('overlay');
    }

    public function setOverlay($overlay)
    {
        $this->_overlay = $overlay;
    }

    function loadStreamValues()
    {
        $this->getVar("debugstream", "off", "");
    }

    function loadCacheValues()
    {
        $this->getVar("checkStart", "on", "");
        $this->getVar("cleanStart", "off", "");
        $this->getVar("cleanExit", "off", "");
        $this->getVar("maxFile", "2000", "");
        $this->getVar("minFreeSpace", "0.3", "");
        $this->getVar("maxFileAge", "86400s", "");
        $this->getVar("maxFileSize", "512KB", "");

        $this->getVar("LMFactor", "0.10", "");
        $this->getVar("maxDuration", "7200s", "");
        $this->getVar("maxDurationFile", "30s", "");
        $this->getVar("minDuration", "10s", "");
        $this->getVar("errorDuration", "300s", "");
        $this->getVar("errorDurationFile", "30s", "");
    }

    // WebRTC
    public function getEchoCancellation()
    {
        return $this->getVar("echoCancellation", "off") == "on" ? true : false;
    }

    public function setEchoCancellation($echoCancellation)
    {
        $this->_echoCancellation = $echoCancellation ? "on" : "off";
    }
}
