<?php

class Mode extends CComponent
{
    public $resolution = null;
    public $vfreq = null;

    public $fixeddb = null;
    public $type=null;
    public $custom = null;

    public $customforcear = '';

    public $simpledisplay=false;
    public $advancedtype=false;

    public static function get($modes, $output = '')
    {
        if (isset($modes[$output])) {
            return $modes[$output];
        } else if (isset($modes['default'])) {
            return $modes['default'];
        } else {
            return null;
        }
    }

    public static function stringify($resolution, $refresh, $aspect)
    {
        if ($resolution && $refresh) {
            $modeString = $resolution . '@' . $refresh . 'Hz';
            $aspectRatio = explode(':', $aspect);
            if (count($aspectRatio) == 2 && $aspectRatio[0] != 0) {
                $modeString .= ' (' . $aspect . ')';
            }
            return $modeString;
        } else {
            return null;
        }
    }

    public function getForceStdMode()
    {
        return $this->fixeddb=='yes';
    }

    public function getModeString()
    {
        return self::stringify(
            $this->resolution,
            $this->vfreq,
            $this->customforcear
        );
    }
}

