<?php
class SystemAction extends CAction
{
    static function backup( ){
        $configBackup = new ConfigBackup;
        if ( isset( $_POST['ConfigBackup'] ) ){
            $configBackup->setAttributes( $_POST['ConfigBackup'] );
            $configBackup->save();
		} 
        return array( 
            'configBackup' => $configBackup
        );
    }
    
    static function playerName( $playerConfig = null ){
        if ( !$playerConfig ){
            $playerConfig = new PlayerConfig;
        }        
        if ( isset( $_POST['PlayerConfig'] ) ) {
            $playerConfig->setScenario( 'id'  );
            $playerConfig->setAttributes( $_POST['PlayerConfig'] );
            if ( $playerConfig->validate()  ) {
                $playerConfig->saveConfig();                
            }
        }
        return array( 'playerConfig' => $playerConfig );
    }
    
    static function timeZone() {
        $timeSettings = new TimeSettings;
        if ( isset($_POST['TimeSettings']) ){
        
            $timeSettings->setScenario('timezone');
            $timeSettings->setAttributes( $_POST['TimeSettings'] );
            
            if ( $timeSettings->validate() )
                $timeSettings->save();
            
        } 
        $timeSettings->load();
        
		return array( 
            'timeSettings' => $timeSettings 
        );
    }
    
    static function playerTime() {
        $ntpSettings = new NTPSettings;
        $ntpSettings->load();
        if ( isset($_POST['NTPSettings']) ){
            if ( $_POST['NTPSettings']['active']==0 )
                $ntpSettings->setScenario('manual');
            else {
                $ntpSettings->setScenario('ntp');
                $ntpSettings->loadTime();
            }
            $ntpSettings->setAttributes( $_POST['NTPSettings'] );
            if ( $ntpSettings->validate() )
                $ntpSettings->save();
            // TODO: check if this is really necessay
            $ntpSettings->load();
        } 
        
       return array( 'ntpSettings' => $ntpSettings );
    }
    
    static function credentials() {
        $credentialsConfig = new CredentialsConfig;
        if ( isset($_POST['Credentials']) ){
            $allOk=true;
            foreach ( $_POST['Credentials'] as $entry ) {
                $credentials = new Credentials;
                $credentials->setAttributes( $entry );
                if ( !$credentials->discard() ) {
                    if ( !$credentials->validate() )
                        $allOk=false;
                    $credentialsConfig->addCreditential($credentials);
                }
            }
            if ( $allOk ) 
                $credentialsConfig->save();            
        } else {
            $credentialsConfig->load();
        }
		return array( 
            'credentialsConfig' => $credentialsConfig 
        );
    }
    static function cockpit() {
        $pullModeConfig = new PullModeConfig;
        $pullModeConfig->load();
        
        if ( isset($_POST['PullModeConfig']) ){
            $pullModeConfig->setAttributes( $_POST['PullModeConfig'] );
            if ( $pullModeConfig->validate() )
                $pullModeConfig->save();
            if ( $pullModeConfig->cockpitUri != null){
                Tools::addMessage("This player is now monitored by Cockpit");
            } else {
                Tools::addMessage("This player is no longer monitored by Cockpit");
            }
        }
        
		return array( 
            'pullModeConfig' => $pullModeConfig,
        );
    }
    static function hardwareSetup()
	{
        if ( Yii::app()->device->model != 'Bonsai' ) {
			$hardwareSetup = new HardwareSetup;
			if ( isset($_POST['HardwareSetup']) ){
				$hardwareSetup->setAttributes( $_POST['HardwareSetup'] );
				$hardwareSetup->save();
			}else {
				$hardwareSetup->load();
			}
            return array( 
                'hardwareSetup' => $hardwareSetup 
            );
		} else {
            return array();
        }
        
	}
    public function run( $concentrator_url = "")
    {
        $options = array( 
            'basicInfo'=> new BasicInfo,            
        );
        $options += self::backup( );
        $options += self::playerName();
        $options += self::timeZone( );        
        $options += self::playerTime();
        $options += self::credentials();
        $options += self::cockpit();
        $options += self::hardwareSetup(  );
        
        $options['concentrator_url'] = $concentrator_url;
        
        $this->controller->name = $options['playerConfig']->deviceName;
        
        $this->controller->renderHybrid( 'system', $options );        
    }
}
