<?php

require( 'DisplayAction.php' );
require( 'SystemAction.php' );

class SummaryAction extends CAction
{
    public function run()
    {
        $wizard = new Wizard();
        $showWizard = isset( $_GET['wizard']);
		if( $wizard->getWelcome() ){            
            $showWizard = true;
        }
        $ARYAMode = new ARYAMode();

        $valid = false;
        if ( isset( $_POST['Wizard']) && isset( $_POST['Wizard']['eula']) && $_POST['Wizard']['eula'] ){
            $valid = true;
        }
        
        if ( !$showWizard && isset( $_GET['arya']) && $_GET['arya'] == "disabled" ){
            $ARYAMode->setEnabled( false );
            return $this->controller->redirect("/");
        }

		$screenInfo = new ScreenInfo;
        $screenInfo->load();
		
		$diskInfo = new DiskInfo;
        $diskInfo->load();
        
        $playerConfig = new PlayerConfig;        
        $user = User::model()->findByPk( Yii::app()->user->id );       
        if ( $user ){
            $user->password = "";
        }
        if ( isset($_POST['User']) ){            
            $user->attributes = $_POST['User'];
            if ( $user->save() ) {
                $user->updateHttpdSecurity();            
            } else {
                //Yii::log('User errors: ' . print_r($user->getErrors(), true), 'debug', 'spx.SummaryAction');
                $valid = false;
            }
        }

        if ($valid) {
            if ( !Tools::checkInstallationmode() && !Tools::doShutdown() ){
                // insure that one reboot will be done
                Tools::addReason("initial configuration");                
            }
            $wizard->setActive( false );

            $ARYAMode->setEnabled( false );
        }

        $options = array( 
            'basicInfo'=> new BasicInfo,
            'screenInfo' => $screenInfo,
            'diskInfo' => $diskInfo,
            'user' => $user,
            'wizard' => $showWizard,
            'wizardConfig' => $wizard,
            'ARYAEnabled' => $ARYAMode->getEnabled(),
            'firmwareUpdate' => new FirmwareUpdate,
        );
        
        $options += DisplayAction::display( $playerConfig, null,  "Display" );
        $options += SystemAction::timeZone( );
        $options += SystemAction::backup( );
        $options += SystemAction::cockpit( );
        $options += SystemAction::playerName( $playerConfig );
        $options += DisplayAction::power();
        $options['data'] = array(
            'time' => date("j M Y G:i:s"),
            'unixTime' => time(),
            'uptime' => $options['basicInfo']->uptimeStr,
            'cpuInfo' => $options['basicInfo']->cpuInfo,
            'storage' => $options['diskInfo']->local,
            'screenInfo' => $options['screenInfo']->monitors[0],
            'firmware' => $options['basicInfo']->getFirmwareStr(),
            'power' => $options['basicInfo']->power
        );    
        if ( Yii::app()->getRequest()->getPost('wizard') ){
            if ($valid && (Tools::doShutdown() || Tools::checkInstallationmode())){
                Tools::shutdown( true );                
                if ( Yii::app()->user->getState('autolog') ) {
                    Tools::$redirect = "/";
                    Yii::app()->user->setState('autolog', false);
                    Yii::app()->user->logout();
                } else {
                    Tools::$redirect = "/" . Yii::app()->getRequest()->getPathInfo();
                }
            } else {
                Tools::$redirect = "/" . Yii::app()->getRequest()->getPathInfo();
            }
        }
        $this->controller->renderHybrid( 'index', $options );
		
    }
}
