<?php

class IPCheck  {
	
	protected $scheme = "http";
	protected $host = "download.spinetix.com";
	protected $path = "/content/netcheck/netcheck.html";
	
	var $codes = array(
		0 => "Success",
		1 => "Timed out",
		2 => "Cannot resolve hostname",
		3 => "File not found",
		4 => "Must Use Proxy",
		5 => "Proxy Authentication Required",
        6 => "Proxy Configuration Error",
        7 => "Wrong content",
        8 => "Proxy Timed out",
        9 => "Redirect",
        10 => "Other errors",
	);
	var $phrase="";
	var $location;
	var $content;
	
	public function resolve() {
		if ( gethostbyname($this->host)==$this->host )
			return 2;
		return 0;
	}
	public function ping() {
		$ret = $this->_ping();
		if ( $ret!=0 && $this->phrase=="" && isset($this->codes[$ret]) )
			$this->phrase = $this->codes[$ret];
		return $ret;
	}
	public function _ping() {
        $proxy = new ProxyConfig;
		$proxy->load();
		
		$url = $this->scheme ."://" . $this->host . $this->path;
		$opts = array('http' =>
			array(
				'method'  => 'GET',
				'max_redirects' => '2',
                'protocol_version' => 1.1,
				'timeout' => 10, // maximum time is 10s, after that we have a problem
			)
		);
		// check if a proxy is configured and then use it
		if ( $proxy->server!="" ){
			$opts['http']['proxy'] = $proxy->server .":". $proxy->port;
            $opts['http']['request_fulluri']=true;
			if ( $proxy->username!="" ) {
				// should do something about this like the code below
				$auth = base64_encode( $proxy->username.":".$proxy->password);
				$opts['http']['header'] = "Proxy-Authorization: Basic $auth";
			}
		}
		
		// do the request
        $errMsg = "";
		$context = stream_context_create($opts);
		try {
    		$stream = @fopen( $url, 'r', false, $context );
	    } catch ( Exception $e ) {
            $errMsg = $e->getMessage();            
        }       
        if ( $stream===false ) {
            $err = error_get_last();
            if ( !empty( $err) ){
                $errMsg = $err['message'];
            } else if ( isset($http_response_header[0]) ){
                $errMsg = $http_response_header[0];
            } else if (isset($php_errormsg) ){
                $errMsg = $php_errormsg;
            } else if ( $errMsg == "" ){
                $errMsg = "Unknown error";
            }
            $this->phrase = $errMsg;
            
            if (strpos( $errMsg, "gethostbyname")!==false ){
                return 2;
            }
            if ( strpos( $errMsg, "HTTP/1.0 407")!==false || strpos( $errMsg, "HTTP/1.1 407")!==false) {
                return 5;
            }
            if ( strpos( $errMsg, "HTTP/1.0 305")!==false || strpos( $errMsg, "HTTP/1.1 305")!==false) {
                return 4;
            }
			if ( strpos( $errMsg, "HTTP/1.0 404")!==false || strpos( $errMsg, "HTTP/1.1 404")!==false) {
                return 3;
            }     
            if ( strpos( $errMsg, "Connection timed out")!==false ) {
                if ( $proxy->server!="" )
                    return 8;
                else
                    return 1;
            }                        
            if ( $proxy->server!="" )
                return 6;
            else
                return 2;
        }
		$meta = stream_get_meta_data( $stream );
		$content = stream_get_contents( $stream, 4096 );
		fclose($stream);
		
		
		if ( $meta['timed_out']==true ) {
			if ( $proxy->server!="" )
                return 8;
            else
                return 1;
		}
		// read the status lines;
		$status = $meta['wrapper_data'];
		$redirect = false;
		foreach ( $status as $code ){
			$header = explode(" ", $code, 2);
			if ( $header[0] == "Location:" ){
				$this->location = $header[1];
            }
            if ( $header[0] == "HTTP/1.0" || $header[0] == "HTTP/1.1"){
				$status_code = explode(" ", $code, 3 );
                if ( $status_code[1]==301 || $status_code[1]==302 || $status_code[1]==303 || $status_code[1]==307 ){
                    $redirect = true;
                    return 9;
                }
            }
		}
		switch ( $status_code[1] ) {
			case 200: break; // we are good
			case 305: return 4;
			case 407: return 5;
			case 404: return 3;                
			default:
				$this->phrase = $status_code[2];
				return 10;
		}
		// check content
		if ( strpos($content, "<TITLE>Success</TITLE>")==false ) {
			$this->content = $content; // to help 
			return 7;
		}
		return 0;
	}
}
