<?php
class ControlCenterController extends Controller
{
    public $response = array();
    protected $uniqueId = 0;

    public $pages;

    public function accessRules()
    {
        $rules = array(
            array('allow', 'roles' => array('useControlCenter')),
            array('deny', 'users' => array('*')),
        );

        return $rules;
    }

    function errorSummary($model)
    {
        Yii::app()->clientScript->registerScript(
            'yiiErrors',
            "var yiiErrors = [];",
            CClientScript::POS_BEGIN
        );
        $script = "";
        foreach ($model->getErrors() as $errors) {
            foreach ($errors as $error) {
                $script .= 
                    "yiiErrors.push( ".CJavaScript::encode($error)." );\n";
            }
        }
        echo CHtml::script($script) . "\n";
    }

    public function renderHybrid($view, $options)
    {
        if (Yii::app()->request->isAjaxRequest) {
            $this->layout = '//layouts/jason';
            $data = null;
            $messages = null;
            $errors = array();
            if (isset($options['data'])) {
                $data = $options['data'];
                unset($options['data']);
            }
            if (isset($options['messages'])) {
                $messages = $options['messages'];
                unset($options['messages']);
            }
            foreach ($options as $obj) {
                if (!is_object($obj)) {
                    continue;
                }
                $errors = $this->updateErrors($obj, $errors);
            }
            $this->render('/layouts/ajax', array(
                'errors' => $errors,
                'messages' => $messages,
                'data' => $data,
            ));
        } else {
            $this->render($view, $options);
        }
    }
    public function updateErrors($model, $errors = array())
    {
        foreach ($model->getErrors() as $name => $error) {
            $previousErrors = array();
            foreach ($error as $e) {
                if (!in_array($e, $previousErrors)) {
                    if (!empty($name)) {
                        $errors[] =
                            $model->getAttributeLabel($name) . ": " . $e;
                    } else {
                        $errors[] = $e;
                    }
                    $previousErrors[] = $e;
                }
            }
        }
        return $errors;
    }
    public function init()
    {
        parent::init();

        $this->layout = '/layouts/base';
        $applicationsVisible =
            Yii::app()->branding->hasRight('interactivity') |
            Yii::app()->branding->hasRight('interactivity') |
            Yii::app()->branding->hasRight('netAPI') |
            Yii::app()->branding->hasRight('multiscreen') |
            Yii::app()->branding->hasRight('firmware') |
            Yii::app()->branding->hasRight('pullMode') |
            Yii::app()->branding->hasRight('IPTV') |
            Yii::app()->branding->hasRight('webRtc');

        if (Yii::app()->user->checkAccess('useControlCenter')) {
            $this->pages = array(
                array(
                    'label' => 'Control Center',
                    'url' => array('/controlcenter/main/index'),
                ),
                array(
                    'label' => 'System',
                    'url' => array('/controlcenter/main/system'),
                    'items' => array(
                        array(
                            'label' => 'Configuration Backup',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'Backup',
                            ),
                        ),
                        array(
                            'label' => 'Identity',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'Identity',
                            ),
                        ),
                        array(
                            'label' => 'Time Zone',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'TimeZone',
                            ),
                        ),
                        array(
                            'label' => 'Date & Time',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'DateTime',
                            ),
                        ),
                        array(
                            'label' => 'Hardware Settings',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'Hardware',
                            ),
                            'visible' =>
                                Yii::app()->device->model === 'ikebana',
                        ), // TODO: REMOVE WHEN IMPLEMETED, HIDDEN BY GEN-2129
                        array(
                            'label' => 'Saved Passwords',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'SavedPasswords',
                            ),
                        ),
                        array(
                            'label' => 'Cockpit',
                            'url' => array(
                                '/controlcenter/main/system',
                                '#' => 'Cockpit',
                            ),
                        ),
                    ),
                ),
                array(
                    'label' => 'Display & Audio',
                    'url' => array('/controlcenter/main/display'),
                    'items' => array(
                        array(
                            'label' => 'Display',
                            'url' => array(
                                '/controlcenter/main/display',
                                '#' => 'Display',
                            ),
                        ),
                        array(
                            'label' => 'Audio',
                            'url' => array(
                                '/controlcenter/main/display',
                                '#' => 'Audio',
                            ),
                        ),
                        array(
                            'label' => 'Power',
                            'url' => array(
                                '/controlcenter/main/display',
                                '#' => 'Power',
                            ),
                        ),
                        array(
                            'label' => 'Other',
                            'url' => array(
                                '/controlcenter/main/display',
                                '#' => 'Other',
                            ),
                        ),
                    ),
                ),
                array(
                    'label' => 'Network',
                    'url' => array('/controlcenter/main/network'),
                    'items' => array(
                        array(
                            'label' => 'IP Configuration',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'IP',
                            ),
                        ),
                        array(
                            'label' => 'Ethernet 802.1X',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => '8021X',
                            ),
                            'visible' =>
                                Yii::app()->device->model !== 'ikebana',
                        ),
                        array(
                            'label' => 'Wi-Fi',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Wi-Fi',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'WIFI'
                            ),
                        ),
                        array(
                            'label' => 'NTP',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'NTP',
                            ),
                        ),
                        array(
                            'label' => 'HTTP Proxy',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Proxy',
                            ),
                        ),
                        array(
                            'label' => 'Trusted Certificates',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'HTTPS',
                            ),
                        ),
                        array(
                            'label' => 'Server Certificates',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'ServerCertificates',
                            ),
                        ),
                        array(
                            'label' => 'Server Security',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'ServerSecurity',
                            ),
                        ),
                        array(
                            'label' => 'Bonjour',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Bonjour',
                            ),
                        ),
                        array(
                            'label' => 'UPnP',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'UPnP',
                            ),
                        ),
                        array(
                            'label' => 'Logging',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Logging',
                            ),
                        ),
                        array(
                            'label' => 'Watchdog',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Watchdog',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'networkWatchdog'
                            ),
                        ),
                        array(
                            'label' => 'SNMP',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'SNMP',
                            ),
                        ),
                        array(
                            'label' => 'Port Security ',
                            'url' => array(
                                '/controlcenter/main/network',
                                '#' => 'Ports',
                            ),
                            'visible' =>
                                Yii::app()->branding->product == 'HMP350',
                        ),
                    ),
                ),
                array(
                    'label' => 'Content',
                    'url' => array('/controlcenter/main/content'),
                    'items' => array(
                        array(
                            'label' => 'Scheduled Download',
                            'url' => array(
                                '/controlcenter/main/content',
                                '#' => 'Download',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'pullMode'
                            ),
                        ),
                        array(
                            'label' => 'Live Sources',
                            'url' => array(
                                '/controlcenter/main/content',
                                '#' => 'Live',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'contentLiveSource'
                            ),
                        ),
                        array(
                            'label' => 'Splash Screens',
                            'url' => array(
                                '/controlcenter/main/content',
                                '#' => 'Splash',
                            ),
                        ),
                    ),
                ),
                array(
                    'label' => 'Peripherals',
                    'url' => array('/controlcenter/main/peripherals'),
                    'items' => array(
                        array(
                            'label' => 'Serial',
                            'url' => array(
                                '/controlcenter/main/peripherals',
                                '#' => 'Serial',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'peripheralsSerial'
                            ),
                        ),
                        array(
                            'label' => 'Automation',
                            'url' => array(
                                '/controlcenter/main/peripherals',
                                '#' => 'FSM',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'peripheralsFSM'
                            ),
                        ),
                        array(
                            'label' => 'USB',
                            'url' => array(
                                '/controlcenter/main/peripherals',
                                '#' => 'USB',
                            ),
                        ),
                        array(
                            'label' => 'Capture',
                            'url' => array(
                                '/controlcenter/main/peripherals',
                                '#' => 'Capture',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'peripheralsCapture'
                            ),
                        ),
                    ),
                ),
                array(
                    'label' => 'Advanced Applications',
                    'url' => array('/controlcenter/main/applications'),
                    'items' => array(
                        array(
                            'label' => 'Interactivity',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'Interactivity',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'interactivity'
                            ),
                        ),
                        array(
                            'label' => 'Touchscreen',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'Touchscreen',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'interactivity'
                            ),
                        ),
                        array(
                            'label' => 'Network API',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'SV',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'netAPI'
                            ),
                        ),
                        array(
                            'label' => 'APIs Security',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'SecurityRPC',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'netAPI'
                            ),
                        ),
                        array(
                            'label' => 'Mutltiscreen',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'Multiscreen',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'multiscreen'
                            ),
                        ),
                        array(
                            'label' => 'Firmware',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'Firmware',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'firmware'
                            ),
                        ),
                        array(
                            'label' => 'RPC Concentrator',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'RPC',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'pullMode'
                            ),
                        ),
                        array(
                            'label' => 'Pull Mode',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'PullMode',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'pullMode'
                            ),
                        ),
                        array(
                            'label' => 'Output Streaming',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'Streaming',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'IPTV'
                            ),
                        ),
                        array(
                            'label' => 'WebRTC',
                            'url' => array(
                                '/controlcenter/main/applications',
                                '#' => 'WebRTC',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'webRtc'
                            ),
                        ),
                    ),
                    'visible' => $applicationsVisible,
                ),
                array(
                    'label' => 'Operations',
                    'url' => array('/controlcenter/main/operations'),
                    'items' => array(
                        array(
                            'label' => 'Firmware Update',
                            'url' => array(
                                '/controlcenter/main/operations',
                                '#' => 'Firmware',
                            ),
                        ),
                        array(
                            'label' => 'Maintenance',
                            'url' => array(
                                '/controlcenter/main/operations',
                                '#' => 'Maintenance',
                            ),
                        ),
                        array(
                            'label' => 'Reset',
                            'url' => array(
                                '/controlcenter/main/operations',
                                '#' => 'Reset',
                            ),
                        ),
                        array(
                            'label' => 'Support',
                            'url' => array(
                                '/controlcenter/main/operations',
                                '#' => 'Support',
                            ),
                        ),
                    ),
                ),
                array(
                    'label' => 'Logs',
                    'url' => array('/controlcenter/main/logs'),
                    'items' => array(
                        array(
                            'label' => 'Proof of Play',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Proof',
                            ),
                        ),
                        array(
                            'label' => 'Current',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Current',
                            ),
                        ),
                        array(
                            'label' => 'Backup',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Backup',
                            ),
                        ),
                        array(
                            'label' => 'Scheduled Upload',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Upload',
                            ),
                            'visible' => Yii::app()->branding->hasRight(
                                'pullMode'
                            ),
                        ),
                    ),
                    'visible' => Yii::app()->branding->hasRight('log'),
                ),
                array(
                    'label' => 'About',
                    'url' => array('/controlcenter/main/about'),
                ),
            );
        } else {
            $this->pages = array(
                array(
                    'label' => 'Control Center',
                    'url' => array('/controlcenter/main/index'),
                ),
                array(
                    'label' => 'Logs',
                    'url' => array('/controlcenter/main/logs'),
                    'items' => array(
                        array(
                            'label' => 'Proof of Play',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Proof',
                            ),
                        ),
                        array(
                            'label' => 'Current',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Current',
                            ),
                        ),
                        array(
                            'label' => 'Backup',
                            'url' => array(
                                '/controlcenter/main/logs',
                                '#' => 'Backup',
                            ),
                        ),
                    ),
                    'visible' => Yii::app()->branding->hasRight('log'),
                ),
                array(
                    'label' => 'About',
                    'url' => array('/controlcenter/main/about'),
                ),
            );
        }
    }
}
