(function ($) {

    var Locales = {
        init: function (locales, formatName) {
            this.locales = [];
            this.formatName = formatName;

            for (var i = 0; i < locales.length; i++) {
                this.locales.push({
                    id: locales[i],
                    text: formatName(locales[i])
                });
            }
            this.html = this.getHTMLOptions();            
        },
        getHTMLOptions: function () {
            var html = '';            
            var i, c = this.locales.length, locale;

            for (i = 0; i < c; i++) {
                locale = this.locales[i];
                html += '<option value="' + locale.id + '">' + locale.text + '</option>';
            }
            return html;
        },
        addNames: function (select) {
            return $(select).empty().append($(this.html));
        }
    };

    $.fn.locales = function (opts, value) {

        if (typeof opts === "string") {
            if (opts === "val") {
                return $(this).select2("val", value);
            }
            return Locales[opts].apply(Locales, Array.prototype.slice.call(arguments));
        }

        opts = $.extend({}, $.fn.locales.defaults, opts);

        if (!opts.formatName || typeof opts.formatName !== 'function') {
            opts.formatName = function (str) {
                return spxapi.locale.formatLocale(str);
            };
        }
        if (opts.locale.length === 0) {
            opts.locale = spxapi.locale.names;            
        }
        Locales.init(opts.locale, opts.formatName);

        return this.each(function(){
            Locales.addNames(this);     
            $(this).select2({});
            return this;
        });    
    };

    $.fn.locales.defaults = {
        locale: []
    };
})(jQuery);

ko.bindingHandlers.localepicker = {
    'after': ['options', 'foreach'],
    init: function (element, valueAccessor, allBindingsAccessor) {
        //initialize timezonepicker with some optional options
        var options = $.extend({
            width: '100%'
        }, allBindingsAccessor().selectOptions);

        $(element).locales(options);

        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function (element, valueAccessor, allBindings) {
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).locales("val", value);
        return ret;
    }
};

