/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


function Summary( args ) {
    
    var self = {
        currentItem: ko.observable(),
        lastPlayout: ko.observable(),
        lastApps: ko.observable()      
    };
    function getLink( item ){
        if ( item && args.links[item.type] ){
            return args.links[item.type].replace( "%5Bid%5D", item.id );
        } else {
            return "#";
        }
    }
    self.currentLink = ko.computed( function(){
        return getLink( self.currentItem() );
    });
    self.lastPlayoutLink = ko.computed( function(){
        return getLink( self.lastPlayout() );
    });
    self.lastAppsLink = ko.computed( function(){
        return getLink( self.lastApps() );
    });
    
    spxapi.schedule.get({ start: null, end: null}).done( function( data ){
        if ( data.length > 0 ){
            self.currentItem( data[0].resource );
        }
    });
    spxapi.playout.list({ max: 1, sort: 1}).done( function( data ){
        if ( data.length > 0 ){
            self.lastPlayout( data[0] );
        }
    });
    spxapi.apps.list({ max: 1, sort: 1}).done( function( data ){
        if ( data.length > 0 ){
            self.lastApps( data[0] );
        }
    });
    return self;
}