<?php
/* @var $this ConfigController */

$httpsConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Trusted Certificates",
    'id' => "HTTPS",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO,
        "These are the additional, user uploaded, certificates used to verify secure connections through HTTPS."
    );
    $httpsConfig->errorSummary( $sslConfig );
    $headers = array(
        "Name", "Issuer", "Serial Number", 
        "Info",
        "Delete",   
    );
    $options = array(
        "data-bind" => "foreach: certificates",
        "sizes" => array( "col-sm-3", "col-sm-4", "col-sm-3", "col-sm-1", "col-sm-1" )
    );
    $row = array();
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: name"
    ), "");
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: country?(organization+' ('+country+')'):organization"
    ), "");
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: serial"
    ), "");
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-info "), "" ), array( 'certificates/view' ), array(
        "data-bind" => "click: \$parent.doViewCertificate",        
        "class" => "btn btn-sm btn-default btn-block"
    ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), array( 'certificates/delete' ), array(
        "data-bind" => "visible: uploaded, click: \$parent.doRemoveCertificate",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
    $this->widget('BsRow', array( 
        'options' => array( 'data-bind' => 'visible: certificates().length > 0', 'class' => 'table-responsive'),
        'content' => $httpsConfig->table( $headers, array( $row ), $options ) 
    ));
    
    // alternative display option
    echo "<br/>";
    $this->widget( 'DialogButton' , array(
        'label' => 'Add Trusted Certificates', 
        'file' => CHtml::activeName( $sslConfig, "uploadedfile" ),
                            'args' =>   "{ ".
                                            "url: '". CHtml::normalizeUrl( array( 'certificates/add' ) ). "', ".    
                                            "done: addCertificate" .
                                        "}",
        'content' => false
    ));
    
    $httpsConfig->errorSummary( $playerConfig );    
    echo $httpsConfig->activeCheckBox($playerConfig, "HTTPSUseDefaultCA");
        
$this->endWidget();

?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.certificates = ko.observableArray( <?php
    echo CJavaScript::encode( $sslConfig->getFileList( ) );
?> );

yiiModel.doRemoveCertificate = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);
    var opt = {
        url: btn.attr("href"),
        data: { target : item.filename },
        type: 'POST'
    };
    yiiModel.doAjax( yiiModel, ev, opt, function( reponse ) {
        yiiModel.certificates.remove( item );
    });
};
function addCertificate( e, data ) {
    var response = data.result;
    if ( response.success ){
        yiiModel.certificates.push( response.data );        
    }
};

yiiModel.doViewCertificate = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);

    var height = $(window).height() * 0.6;    
    spxapi.ui.modalDialog({
        contentHeight: '100%',
        contentWidth: 650,
        title: item.name,
        body: $("<pre/>").height(height).text( item.text ),
        buttons: [
            { name: "Download Certificate", 
              action: function() { console.log("clicked"); window.location = "<?php echo CHtml::normalizeUrl(array( "certificates/view" )) ?>/target/" + encodeURIComponent( item.filename ); },
              close: false
            }
        ]
    });
};
//]]></script>