<?php

class Region
{
    public $x1 = 0;
    public $y1 = 0;
    public $x2 = 0;
    public $y2 = 0;

    public function width()
    {
        return abs($this->x2 - $this->x1);
    }

    public function height()
    {
        return abs($this->y2 - $this->y1);
    }

    public function setPositionAndSize($x, $y, $width, $height)
    {
        $this->x1 = $x;
        $this->y1 = $y;
        $this->x2 = $x + $width;
        $this->y2 = $y + $height;
    }

    public function setCoordinates($region)
    {
        $this->x1 = $region['x1'];
        $this->y1 = $region['y1'];
        $this->x2 = $region['x2'];
        $this->y2 = $region['y2'];
    }

    public function encompassCoordinates($region)
    {
        $x1 = min($region['x1'], $region['x2']);
        if ($x1 < min($this->x1, $this->x2)) {
            $this->x1 = $x1;
        }
        $y1 = min($region['y1'], $region['y2']);
        if ($y1 < min($this->y1, $this->y2)) {
            $this->y1 = $y1;
        }
        $x2 = max($region['x1'], $region['x2']);
        if ($x2 > max($this->x1, $this->x2)) {
            $this->x2 = $x2;
        }
        $y2 = max($region['y1'], $region['y2']);
        if ($y2 > max($this->y1, $this->y2)) {
            $this->y2 = $y2;
        }
    }
}

