<?php
/* @var $this MainController */

$this->registerSpxScript( 'resources.js' );
$this->registerSpxScript( 'work.js' );
$this->breadcrumbs[] = $this->title = I18N::t('Templates'); 

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array( 
         array( 'preset'=> 'upload', 'title' => I18N::t('Upload Backup'),
                'html' => '<input type="file" name="media" data-bind="jQueryFileupload: resources.addMediaFile, args: {url: spxapi.media.uri} " />',
                'id'=>"uploadButton",
                'visible' => Yii::app()->user->checkAccess('uploadMedia')
        ),
        array( 'preset'=> 'new',
                'title' => I18N::t('New Template'),
                'data-bind' => 'click: create'
        )
    ),
    'options' => array( 
        "class" => "pull-right",
        
    )    
), true); 
$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array( 
        array( 'preset'=> 'remove',
                'data-bind' => 'click: deleteResources, css: { disabled: resources.selected().length === 0 }',
                'id'=>"deleteButton",
                'visible' => Yii::app()->user->checkAccess('deleteMedia')
        ),
        array( 'preset'=> 'backup',
                'data-bind' => 'click: backupResources, css: { disabled: resources.selected().length === 0 }',
                //'onclick' => 'location.href = "'.$this->createUrl("/api/backup/create").'"; loadButtonWithCheck( $(this) );',
                'id'=>"backupButton"
        ),                
    ),
    'options' => array( 
        "class" => "pull-right"
    )
), true); 

?>
<div class="row" >
    <div class='col-md-12' data-bind="with: resources">
<?php
$this->widget('AssetsSelect', array(   
    'tableOptions'=>array( "id"=>"iconViewTable" ),
    'selectOptions'=>array( "id"=>"iconViewSelect" ),
    'direction' => true
));
?>    
    </div>
</div>
<script type="text/javascript" >
//<![CDATA[
<?php
    $models = array( 'template' );
    $actions = array( 'delete', 'edit', 'copy' );
    
    $resources = array();
    $visible = array();
    foreach ( $models as $idx => $model ){
        if ( Yii::app()->user->checkAccess('view'. ucfirst($model)) ) {
            $resources[] = $model;
        }
        foreach ( $actions as $action ){
            if ( !Yii::app()->user->checkAccess( $action. ucfirst($model)) ) {
                $visible[$model][$action] = false;
            }
        }
    }
    $options = array(
        "links" => array(
            "playout" => $this->createUrl("template/edit", array('id'=>"[id]") ),
            "template" => $this->createUrl("template/edit", array('id'=>"[id]") ),
            "backup" => $this->createUrl("/api/backup/create", array('ids'=>"[id]") ),
        ),
        'resources' => $resources,
        'visible' => $visible,
        'noNewPlayout' => true
    );    
?>
var model = new WorkEdit(<?php echo CJavaScript::encode( $options ); ?>);

ko.applyBindings( model );
//]]></script>
