<?php
/* @var $this MediaController */
// If neededing additonal scripts
//Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/ascript/file',CClientScript::POS_END);

$this->breadcrumbs = array( 
    "Media" => array( "playing/create", 'filter'=>'media' ),
    "ko" =>"breadcrumbs"
);
$this->title = I18N::t("Media");
$this->registerSpxScript( 'media.js' );
$this->registerSpxScript( 'resources.js' );

$agent = Yii::app()->request->userAgent;
if ( strpos($agent, 'iPhone OS 7') === false && strpos($agent, 'iPad OS 7') === false ){
    $multiple = 'multiple="multiple" ';
} else {
    $multiple = "";
}

$baseUrl = Yii::app()->baseUrl; 
$cs = Yii::app()->getClientScript();
$cs->registerScriptFile($baseUrl.'/js/darkroom/fabric.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/darkroom.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/stringview.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/plugins/darkroom.crop.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/plugins/darkroom.rotate.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/plugins/darkroom.history.js', CClientScript::POS_BEGIN );
$cs->registerScriptFile($baseUrl.'/js/darkroom/plugins/darkroom.save.js', CClientScript::POS_BEGIN );
$cs->registerCssFile( $baseUrl.'/js/darkroom/darkroom.css' );

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'preset'=> 'upload',                
                'html' => '<input type="file" '.$multiple.'name="media" data-bind="jQueryFileupload: updateMedia, args: { mediaOnly: true, url: spxapi.media.uri + '.$id.' } " />',
                'id'=>"uploadButton",
                'visible' => Yii::app()->user->checkAccess('uploadMedia')
        ),
        array( 'preset'=> 'apply',
                'data-bind' => 'click: apply, visible: status.isDirty()')
    ),
    'options' => array( 
        "class" => "pull-right"
    )
), true); 

  
?>
<div>
    <div class="row clearfix" data-bind="with: media">  
        <div class="col-lg-push-8 col-lg-4 col-md-push-6 col-md-6">
            <div class="panel" >
                <div class="panel-heading">
                    Media
                </div>
                <div class="panel-body">
<?php 
$this->widget('PropertiesInput', array(
    'src' => 'properties'
)); 
?>                      
                </div>
            </div>            
        </div>
        <div class="col-lg-pull-4 col-lg-8 col-md-pull-6 col-md-6">
            <div data-bind="if: img">
                <!--img style="width:100%" class="preview" data-bind="darkroom: img, saveUri: manage"/-->
                <img class="preview img-responsive" style="width:100%" data-bind="attr: {src: img, alt: name }"/>
            </div>
            <div data-bind="ifnot: img">
                <img style="max-width:100%" class="preview" data-bind="attr: { alt: name, src: preview()}"/>                               
            </div>           
        </div>
        
    </div>    
</div>

<script type="text/javascript" >
//<![CDATA[
<?php
    $options = array();
    if ( isset($id) ){
        $options['id']= $id;
    }
    if ( Yii::app()->user->checkAccess('manageTemplate') ){
        $options['manageTemplate']= true;
    }
?>
var model = new MediaEdit(<?php echo CJavaScript::encode( $options ); ?> );

ko.applyBindings( model );

//]]></script>
